#include <iostream>
#include <cstdio>
#include <bitset>
#include <vector>
#include <algorithm>
#include "testlib.h"
using namespace std;

int main(int argc, char *argv[])
{
    registerTestlibCmd(argc, argv);
    int n = inf.readInt(), p = inf.readInt(), M = inf.readInt();
    vector<vector<bool>> e(n * 2, vector<bool>(n * 2, false));
    for (int i = 0; i < p; i++)
    {
        int a = inf.readInt(1, n), b = inf.readInt(n + 1, 2 * n);
        a--, b--;
        e[a][b] = true;
    }
    int m = ouf.readInt(1, M);
    vector<string> s(2 * n);
    for (int i = 0; i < 2 * n; i++)
    {
        s[i] = ouf.readToken();
        if ((int)s[i].size() != m)
            quitf(_wa, "The length of %d-th identifier is not equal to %d", i, m);
    }
    vector<string> t = s;
    sort(t.begin(), t.end());
    for (int i = 1; i < (int)t.size(); i++)
        if (t[i] == t[i - 1])
            quitf(_wa, "The identifier must be distinct");
    if (n <= 100)
    {
        const int M = 10200;
        vector<bitset<M * 3>> val(2 * n);
        for (int i = 0; i < 2 * n; i++)
        {
            for (int j = 0; j < (int)s[i].size(); j++)
                if (s[i][j] == 'A')
                    val[i][3 * j] = 1;
                else if (s[i][j] == 'B')
                    val[i][3 * j + 1] = 1;
                else if (s[i][j] == 'C')
                    val[i][3 * j + 2] = 1;
                else
                    quitf(_wa, "The identifier must consist of A,B,C");
        }
        for (int u = 0; u < n; u++)
            for (int v = 0; v < n; v++)
                if (!((val[u] & val[v]).any()))
                    quitf(_wa, "(%d, %d) are not connected", u, v);
        for (int u = n; u < 2 * n; u++)
            for (int v = n; v < 2 * n; v++)
                if (!((val[u] & val[v]).any()))
                    quitf(_wa, "(%d, %d) are not connected", u, v);
        for (int u = 0; u < n; u++)
            for (int v = n; v < 2 * n; v++)
                if (e[u][v])
                {
                    if (!((val[u] & val[v]).any()))
                        quitf(_wa, "(%d, %d) are not connected", u, v);
                }
                else
                {
                    if ((val[u] & val[v]).any())
                        quitf(_wa, "(%d, %d) are connected", u, v);
                }
        quitf(_ok, "Accepted");
    }
    else
    {
        const int M = 3000;
        vector<bitset<M * 3>> val(2 * n);
        for (int i = 0; i < 2 * n; i++)
        {
            for (int j = 0; j < (int)s[i].size(); j++)
                if (s[i][j] == 'A')
                    val[i][3 * j] = 1;
                else if (s[i][j] == 'B')
                    val[i][3 * j + 1] = 1;
                else if (s[i][j] == 'C')
                    val[i][3 * j + 2] = 1;
                else
                    quitf(_wa, "The identifier must consist of A,B,C");
        }
        for (int u = 0; u < n; u++)
            for (int v = 0; v < n; v++)
                if (!((val[u] & val[v]).any()))
                    quitf(_wa, "(%d, %d) are not connected", u, v);
        for (int u = n; u < 2 * n; u++)
            for (int v = n; v < 2 * n; v++)
                if (!((val[u] & val[v]).any()))
                    quitf(_wa, "(%d, %d) are not connected", u, v);
        for (int u = 0; u < n; u++)
            for (int v = n; v < 2 * n; v++)
                if (e[u][v])
                {
                    if (!((val[u] & val[v]).any()))
                        quitf(_wa, "(%d, %d) are not connected", u, v);
                }
                else
                {
                    if ((val[u] & val[v]).any())
                        quitf(_wa, "(%d, %d) are connected", u, v);
                }
        quitf(_ok, "Accepted");
    }
    return 0;
}
